const express = require("express");
const router = express.Router();
const eventController = require("../controllers/eventController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

// public Routes
router.route("/").get(checkApiKey, eventController.getAllEvents);
router.route("/:id").get(checkApiKey, eventController.getEventById);

router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));
router.route("/").post(eventController.createEvent);

// Routes for '/:id'

router
  .route("/:id")
  .put(eventController.updateEvent)
  .delete(eventController.deleteEvent);

module.exports = router;
